//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.IO;
using System.Net;
using System.Net.Sockets;

namespace AsyncClnt
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class AsyncClientClass
	{
		static void Main(string[] args)
		{
			string server = "localhost";
			if(args.Length == 1)
				server = args[0];
			TcpClient client = new TcpClient();
			client.Connect(server, 5000);
			NetworkStream tcpStream = client.GetStream();
			// Uzyskanie StreamWriter, dziki czemu mona zapisywa cigi zamiast bajtw
			StreamWriter reqStreamW = new StreamWriter(tcpStream);
			// Tutaj naley umieci kod pozwalajcy na uycie serwera TCP, na przykad
			// ponisze wiersze zapisuj cig w strOutData na serwer:
			reqStreamW.Write("Witaj serwerze!");
			// Uycie StreamWriter do wysania danych
			reqStreamW.Flush();
			// Uzyskanie StreamReader sw celu odczytania cigw zamiast bajtw
			StreamReader reqStreamR = new StreamReader(tcpStream);
			// Ponisza instrukcja odczytuje cig z serwera:
			String strInData = reqStreamR.ReadToEnd();
			Console.WriteLine(strInData);
			// Zamknicie strumienia i klienta
			tcpStream.Close();
			client.Close();
		}
	}
}
